package ws.afterglo.audioPod;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.Iterator;
import java.util.Arrays;

/**
 * @author philippe & northernlad
 *  
 */
public class WaScrobbler {
	private Logger logger;
	private static String cachePath;
	private int nbSongsCached;
	private int nbSongsTotal;
	private ArrayList recentPlayes;
//	Converted allCachedSongs back to TreeList to enable easy sorting.
//  Please see getCachedTracks() for conversion into ArrayList.
	private TreeSet allCachedSongs;
	private UI ui;
	
	public WaScrobbler(UI ui) {
		this.logger = Logger.getLogger(this.getClass().getPackage().getName());
		this.recentPlayes = AudioPod.recentplayed;
		allCachedSongs = new TreeSet();
		cachePath=AudioPod.waCachePath;
		this.ui=ui;
	}
	
	public boolean writeCache() {
		boolean succ=true;
		nbSongsTotal=AudioPod.recentplayed.size();
		if (nbSongsTotal == 0)
			return true;
		else {
			try {
				//update cache
				BufferedWriter bw = new BufferedWriter(new FileWriter(cachePath));
				bw.write(createCacheString());
				if (bw != null) bw.close();

				logger.log(Level.INFO, (AudioPod.toSubmit.size()-AudioPod.iPodShortCount)+" tracks written to Winamp cache");
				if(!AudioPod.delPlaysEnabled)
					logger.log(Level.INFO, "You must now sync your iPod with your"
										+ " music management software or delete"
										+ " 'Play Counts' from the iTunes folder!");
				
				//job done; disable the buttons to avoid abuse
				ui.disableCacheB();
				ui.disableSubmitB();
				
			} catch (Exception e) {
				logger.log(Level.SEVERE, e.toString());
				succ=false;
			}
		}
		return succ;
	}

	public String createCacheString() {
		String cacheString = "";
		int tracknum = 0;
		Iterator itr = AudioPod.toSubmit.iterator();

		while (itr.hasNext()) {
			TrackItem track = (TrackItem) itr.next();
			if (track.getLength() < 30) {
				continue;
			}
			
			String artist=track.getArtist();
			cacheString+=artist;
			for(int i=0;i<128-artist.length();i++)
				cacheString+=(char)0;
			
			String trackName=track.getTrack();
			cacheString+=trackName;
			for(int i=0;i<128-trackName.length();i++)
				cacheString+=(char)0;
			
			String album=track.getAlbum();
			cacheString+=album;
			for(int i=0;i<256-album.length();i++)
				cacheString+=(char)0;
			
			Date date = new Date(track.getLastplayed() * 1000);
			SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			dformat.setTimeZone(TimeZone.getTimeZone("GMT:00"));
			String datestring = dformat.format(date);
			cacheString+=datestring+(char)0;
			
			String length="";
			length+=track.getLength();
			cacheString+=length;
			for(int i=0;i<6-length.length();i++)
				cacheString+=(char)0;
			
			String path=track.getTrackPath();
			if(path.equals(""))
				path="AudioPod";
			cacheString+=path;
			for(int i=0;i<260-path.length();i++)
				cacheString+=(char)0;
			
			String format=track.getFormat();
			if(format.equals(""))
				format="MP3";
			cacheString+=format;
			for(int i=0;i<5-format.length();i++)
				cacheString+=(char)0;
			
			tracknum++;
		}
		return cacheString;
	}

	public int addToOtherSongs() {
		int tracknum = nbSongsCached;

		for (int i = 0; i < recentPlayes.size(); i++) {
			TrackItem track = (TrackItem) AudioPod.recentplayed.get(i);
			allCachedSongs.add(track);
			tracknum++;
		}
		return tracknum;
	}

	public void parseCache(){
		String cache = "";
		try {
			BufferedReader in = new BufferedReader(new FileReader(cachePath));
			cache = in.readLine();
			in.close();
		} catch (Exception e) {
			return;
		}
		
		int head;
		int tail;
		int nbSongs=cache.length()/803;
		for(int i=0;i<nbSongs;i++){

			//Get Artist
			head=i*803;
			tail=head+127;
			while(cache.charAt(tail)==(char)0){
				tail--;
			}
			String artist=cache.substring(head, tail+1);
			
			//Get Track title
			head+=128;
			tail=head+127;
			while(cache.charAt(tail)==(char)0){
				tail--;
			}
			String title=cache.substring(head, tail+1);
			
			//Get Album
			head+=128;
			tail=head+255;
			while(cache.charAt(tail)==(char)0){
				tail--;
			}
			String album=cache.substring(head, tail+1);
			
			//Get Date played
			head+=256;
			tail=head+19;
	        String date = cache.substring(head, tail);    
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			sdf.setTimeZone(TimeZone.getTimeZone("GMT:00"));
			long time = 0;
			try {
				time = sdf.parse(date).getTime()/1000;
			} catch (Exception e) {
				logger.log(Level.SEVERE, "Wrong date format to convert to timestamp");
			}
			
			//Get length
			head+=20;
			tail=head+5;
			while(cache.charAt(tail)==(char)0){
				tail--;
			}
			long length = Long.parseLong(cache.substring(head, tail+1));
			
			//Get path
			head+=6;
			tail=head+259;
			String path = cache.substring(head, tail+1);
			
			//Get format
			head+=260;
			tail=head+4;
			String format = cache.substring(head, tail+1);
			
			TrackItem track = new TrackItem();
			
			track.setArtist(artist);
			track.setTrack(title);
			track.setAlbum(album);
			track.setLength(length);
			track.setLastplayed(time);
			//TODO: read MBID
			//track.setMBID("643523");
			track.setSource("Winamp");
			track.setTrackPath(path);
			track.setFormat(format);
			allCachedSongs.add(track);
		}
		AudioPod.winampCount=nbSongs;
	}

	public static void clearCache(){
		//delete cache file if it exists
		File cache=new File(cachePath);
		if(cache.isFile())
			cache.delete();
	}
	
	public ArrayList getCachedTracks()
	{
		/* since allCachedSongs is a TreeSet and we need to return an 
		 * ArrayList a little typecasting needs to be done.
		 */
		return new ArrayList(Arrays.asList(allCachedSongs.toArray()));	
	}
}